﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public abstract class Weapon : ScriptableObject
{
	protected WeaponBehaviour behaviour;

	public float shotRange;
	public float shotInterval;
	protected float shotTimer;
	public int damage;
	public int damageRandomRange;

	public bool IsReady { get { return shotTimer <= 0; } }

	public virtual void Init(WeaponBehaviour behaviour)
	{
		this.behaviour = behaviour;
		shotTimer = shotInterval;
	}

	public virtual void UpdateWeapon(float deltaTime)
	{
		shotTimer = Mathf.Max(0, shotTimer - deltaTime);
	}
	public abstract void OnAttack(Enemy enemy);
}
