﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public abstract class Skill : ScriptableObject
{
    protected PlayableCharacter character;
    protected WeaponBehaviour weaponBehaviour;

    public int tier;
    public int index;

    public virtual void Init(PlayableCharacter character)
    {
        this.character = character;
        this.weaponBehaviour = character.GetComponent<WeaponBehaviour>();
    }

    public abstract void Aiming();
    public abstract void Use();
}
