﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;

#if UNITY_EDITOR
public class AssetMakerWindow : EditorWindow
{
    private MonoScript script;
    private Skill skill;

    [MenuItem("Tools/AssetMaker")]
    static void Init()
    {
        AssetMakerWindow window = (AssetMakerWindow)GetWindow(typeof(AssetMakerWindow));
        window.Show();
    }

    private void OnGUI()
    {
        skill = EditorGUILayout.ObjectField(skill, typeof(MonoScript), false) as Skill;
        if (GUILayout.Button("Make!"))
        {
            if (!skill)
                return;
            AssetDatabase.CreateAsset(skill, skill.GetType().Name + ".asset");
        }
    }
}
#endif