﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace BS {
    public class NodalPathfinding2DAgent : MonoBehaviour
    {
        public NodalPathfinding2D pathFinder;

        public Vector3 destination;
        public List<Vector3> path = new List<Vector3>();
		public float moveSpeed;

        float t = 0.5f;

        public bool isGizmos = true;

        private void OnDrawGizmos()
        {
            if (!isGizmos)
                return;
            Gizmos.color = Color.white;
            if (path.Count > 0)
            {
                Gizmos.DrawLine(transform.position, path[0]);
                for (int i = 0; i < path.Count - 1; i++)
                {
                    Gizmos.DrawLine(path[i] + new Vector3(0,0,1), path[i + 1] + new Vector3(0, 0, 1));
                }
                Gizmos.color = Color.red;
                Gizmos.DrawSphere(destination + new Vector3(0, 0, 1), 0.5f);
            }
        }

        private void Update()
        {
			/*
            t -= Time.deltaTime;
            if (t < 0)
            {
                MoveTo(new Vector2(Random.Range(pathFinder.bounds.min.x, pathFinder.bounds.max.x), Random.Range(pathFinder.bounds.min.y, pathFinder.bounds.max.y)));
                t = 0.5f;
            }
			*/


            if (Input.GetKeyDown(KeyCode.Space))
            {
                transform.position = new Vector2(Random.Range(pathFinder.bounds.min.x, pathFinder.bounds.max.x), Random.Range(pathFinder.bounds.min.y, pathFinder.bounds.max.y));
            }
            if (Input.GetMouseButtonDown(1))
            {
                MoveTo(Camera.main.ScreenToWorldPoint(Input.mousePosition));
            }
            //path = pathFinder.GetPathGreedy(transform.position, destination);
        }

        public void MoveTo(Vector3 destination)
        {
            this.destination = destination;
            //path = pathFinder.GetPathGreedy(transform.position, destination);
            path = pathFinder.GetPathAstar(transform.position, destination);
        }

		public void Move(Vector2 direction)
		{

		}
	}
}