﻿using System.Collections;
using System.Collections.Generic;

public class PriorityQueue<T>
{
    private Heap<T> heap;
	
	public int Count { get { return heap.Count; } }

    public PriorityQueue(System.Comparison<T> comparison)
    {
		heap = new Heap<T>(comparison);
    }

    public void Enqueue(T item)
    {
		heap.Insert(item);
    }

    public T Dequeue()
    {
        return heap.Pop();
    }

	public bool Contains(T item)
	{
		return heap.Contains(item);
	}
}

class Heap<T>
{
	private List<T> list = new List<T>();
	private System.Comparison<T> comparison;

	public int Count { get { return list.Count; } }

	public Heap(System.Comparison<T> comparison)
	{
		this.comparison = comparison;
	}

	public bool Contains(T item)
	{
		return list.Contains(item);
	}

	public void Insert(T item)
	{
		list.Add(item);
		int index = list.Count - 1;
		while (comparison.Invoke(list[index], list[index / 2]) > 0)
		{
			T tmp = list[index];
			list[index] = list[index / 2];
			list[index / 2] = tmp;
			index /= 2;
		}
	}

	public T Pop()
	{
		T tmp = list[0];
		list[0] = list[list.Count - 1];
		list.RemoveAt(list.Count - 1);
		Heapify();
		return tmp;
	}

	private void Heapify()
	{
		int index = 0;
		while (true)
		{
			int left = 2 * index + 1;
			int right = 2 * index + 2;

			int target = index;
			if (left < list.Count && comparison.Invoke(list[left], list[index]) > 0)
			{
				target = left;
			}
			if (right < list.Count && comparison.Invoke(list[right], list[index]) > 0)
			{
				target = right;
			}
			if (index != target)
			{
				T tmp = list[index];
				list[index] = list[target];
				list[target] = tmp;
				index = target;
			}
			else
			{
				break;
			}
		}
	}
}