﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;

public class DialogueSceneMakerWindow : EditorWindow
{
    [SerializeField]
    public List<Dialogue> dialogues = new List<Dialogue>();

    private string characterName;
    private string dialogueText;
    private int imageIndex;

    Vector2 dialogueScroll;
    private int loadFromDialoguesIndex = 0;

    Rect dialogueAdderWindowRect = new Rect(0, 0, 400, 400);
    Rect dialogueSceneMakerWindowRect = new Rect(400, 0, 400, 600);

    DialogueScene dialogueScene = null;

    string newFileName;

    [MenuItem ("Tools/DialogueSceneMaker")]
    static void Init()
    {
        DialogueSceneMakerWindow window = (DialogueSceneMakerWindow)EditorWindow.GetWindow(typeof(DialogueSceneMakerWindow));
        window.minSize = new Vector2(800, 400);
        window.Show();
    }

    private void OnGUI()
    {
        BeginWindows();
        dialogueAdderWindowRect = GUILayout.Window(1, dialogueAdderWindowRect, DialogueAdderWindow, "Dialogue Adder");
        dialogueSceneMakerWindowRect = GUILayout.Window(2, dialogueSceneMakerWindowRect, DialogueSceneWindow, "Dialogue Scene Maker");
        EndWindows();
    }

    void DialogueAdderWindow(int id)
    {
        characterName = EditorGUILayout.TextField("Character Name", characterName, GUILayout.MaxWidth(position.width / 2));
        imageIndex = EditorGUILayout.IntField("Character Image Index", imageIndex, GUILayout.MaxWidth(position.width / 2));
        GUILayout.Label("Dialogue");

        dialogueText = EditorGUILayout.TextArea(dialogueText, GUILayout.Height(200), GUILayout.MaxWidth(position.width / 2));

        if (GUILayout.Button("Add new Dialogue", GUILayout.MaxWidth(position.width / 2)))
        {
            dialogues.Add(new Dialogue(characterName, imageIndex, dialogueText));
            characterName = "";
            imageIndex = 0;
            dialogueText = "";
        }

        EditorGUILayout.BeginHorizontal();
        loadFromDialoguesIndex = EditorGUILayout.IntField(loadFromDialoguesIndex, GUILayout.MaxWidth(position.width / 4));
        if (GUILayout.Button("Add new Dialogue at", GUILayout.MaxWidth(position.width / 4)))
        {
            dialogues.Add(new Dialogue(characterName, imageIndex, dialogueText));
            characterName = "";
            imageIndex = 0;
            dialogueText = "";
        }
        EditorGUILayout.EndHorizontal();

        EditorGUILayout.BeginHorizontal();
        loadFromDialoguesIndex = EditorGUILayout.IntField(loadFromDialoguesIndex, GUILayout.MaxWidth(position.width / 4));
        if (GUILayout.Button("Edit Dialogue at", GUILayout.MaxWidth(position.width / 4)))
        {
            dialogues.Add(new Dialogue(characterName, imageIndex, dialogueText));
            characterName = "";
            imageIndex = 0;
            dialogueText = "";
        }
        EditorGUILayout.EndHorizontal();

        EditorGUILayout.BeginHorizontal();
        loadFromDialoguesIndex = EditorGUILayout.IntField(loadFromDialoguesIndex, GUILayout.MaxWidth(position.width / 4));
        if (GUILayout.Button("Load from current Dialogues", GUILayout.MaxWidth(position.width / 4)))
        {
            Dialogue dialogue = dialogues[loadFromDialoguesIndex];
            characterName = dialogue.characterName;
            imageIndex = dialogue.imageIndex;
            dialogueText = dialogue.dialogue;
        }
        EditorGUILayout.EndHorizontal();

        GUI.DragWindow();
    }

    void DialogueSceneWindow(int id)
    {
        GUILayout.Label("Current dialogue list", EditorStyles.boldLabel);

        /*
        GUILayout.BeginHorizontal();
        dialogueScene = EditorGUILayout.ObjectField(dialogueScene, typeof(DialogueScene), false) as DialogueScene;
        if (GUILayout.Button("Save", GUILayout.Width(100)))
        {

        }
        if (GUILayout.Button("Load", GUILayout.Width(100)))
        {

        }
        GUILayout.EndHorizontal();
        /*
        GUILayout.BeginHorizontal();
        if (GUILayout.Button("Save", GUILayout.Width(100)))
        {

        }
        if (GUILayout.Button("Load", GUILayout.Width(100)))
        {

        }
        GUILayout.EndHorizontal();
        */

        dialogueScroll = GUILayout.BeginScrollView(dialogueScroll);

        var serializedObject = new SerializedObject(this);
        var list = serializedObject.FindProperty("dialogues");
        
        for (int i = 0; i < dialogues.Count; i++)
        {
            if (EditorGUILayout.PropertyField(list.GetArrayElementAtIndex(i),new GUIContent("Dialogue " + i.ToString()), true))
            {
                Debug.Log("ASDF");
                var element = list.GetArrayElementAtIndex(i);
                Dialogue dialogue = new Dialogue(
                    element.FindPropertyRelative("characterName").stringValue,
                    element.FindPropertyRelative("imageIndex").intValue,
                    element.FindPropertyRelative("dialogue").stringValue);
                dialogues[i] = dialogue;
            }
            GUILayout.BeginHorizontal();
            GUILayout.FlexibleSpace();

            if (i > 0 && GUILayout.Button("↑", GUILayout.Width(20)))
            {
                Dialogue tmp = dialogues[i];
                dialogues[i] = dialogues[i - 1];
                dialogues[i - 1] = tmp;
                break;
            }
            if (i < dialogues.Count - 1 && GUILayout.Button("↓", GUILayout.Width(20)))
            {
                Dialogue tmp = dialogues[i];
                dialogues[i] = dialogues[i + 1];
                dialogues[i + 1] = tmp;
                break;
            }
            if (GUILayout.Button("+", GUILayout.Width(20)))
            {
                Dialogue tmp = new Dialogue(dialogues[i]);
                dialogues.Insert(i + 1, tmp);
                break;
            }

            if (GUILayout.Button("-", GUILayout.Width(20)))
            {
                dialogues.RemoveAt(i);
                break;
            }
            GUILayout.EndHorizontal();
        }


        //EditorGUILayout.PropertyField(serializedObject.FindProperty("dialogues"), true, GUILayout.MaxWidth(position.width / 2));
        GUILayout.EndScrollView();

        GUI.DragWindow();
    }

    private void DialogueToEditorLayout(Dialogue dialogue)
    {

    }
}
