﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SingletonBehaviour<T> : MonoBehaviour where T : MonoBehaviour
{
	private static T _inst = null;
	public static T inst
	{
		get
		{
			if (_inst == null)
			{
				T[] objects = GameObject.FindObjectsOfType<T>();
				if (objects.Length > 1)
					Debug.LogError("Multiple singleton exists!");
				if (objects.Length > 0)
					_inst = objects[0];
				if (_inst == null)
				{
					GameObject obj = new GameObject(typeof(T).Name);
					_inst = obj.AddComponent<T>();
				}
			}
			return _inst;
		}
	}

	public void SetStatic()
	{
		GameObject.DontDestroyOnLoad(inst.gameObject);
	}
}
