﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

using BS;

public class DialogueScene : ScriptableObject
{
    public List<Dialogue> dialogues = new List<Dialogue>();
    private int dialogueIndex = 0;

    public bool IsEnd { get { return dialogueIndex >= dialogues.Count; } }
    public bool IsStart { get { return dialogueIndex == 1; } }

	public void Init()
	{
		dialogueIndex = 0;
	}

    public Dialogue GetNextDialogue()
    {
        return dialogues[dialogueIndex++];
    }

    public Dialogue GetPrevDialogue()
    {
		return dialogues[--dialogueIndex - 1];
    }
}

[System.Serializable]
public struct Dialogue
{
	public string characterName;
	[TextArea]
	public string dialogue;
	public int characterCount;
	public List<int> characterIDs;
	public List<CharacterExpression> expressions;

	public Dialogue(string characterName, string dialogue, int characterCount, List<int> characterIDs, List<CharacterExpression> expressions)
    {
        this.characterName = characterName;
        this.dialogue = dialogue;
		this.characterCount = characterCount;
		this.characterIDs = characterIDs;
		this.expressions = expressions;
	}

    public Dialogue(Dialogue dialogue)
    {
        this.characterName = dialogue.characterName;
        this.dialogue = dialogue.dialogue;
		this.characterCount = dialogue.characterCount;
		this.characterIDs = dialogue.characterIDs;
		this.expressions = dialogue.expressions;
	}
}