﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

/// <summary>
/// Used for loading dialogue system's character sprite. You can custom this as you needed.
/// </summary>
public enum CharacterExpression
{
	DEFAULT,
	SMILE,
	HAPPINESS,
	SAD,
	CRY,
	DEPRESSION,
	CONFUSED,
	DISPLEASURE,
	ANGRY
}

public class CharacterResource : ScriptableObject
{
	public int characterID;
	public string characterName;
	public Sprite[] characterImageList = new Sprite[Enum.GetNames(typeof(CharacterExpression)).Length];

	public Sprite GetCharacterImage(int index)
	{
		return characterImageList[index];
	}

	public Sprite GetCharacterImage(CharacterExpression expression)
	{
		return characterImageList[(int)expression];
	}
}
