﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;
using BS;

[CustomEditor(typeof(NodalPathfinding2D))]
public class NodalPathfinding2DEditor : Editor
{
    public override void OnInspectorGUI()
    {
        DrawDefaultInspector();
        NodalPathfinding2D myTarget = (NodalPathfinding2D)target;
        if (GUILayout.Button("Bake"))
        {
            myTarget.BakeNodes();
            SceneView.RepaintAll();
        }
        if (GUILayout.Button("Clear"))
        {
            myTarget.ClearNodes();
            SceneView.RepaintAll();
        }
    }
}
