﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using BS;

public abstract class Actor : MonoBehaviour
{
	protected NodalPathfinding2DAgent agent = null;
	[SerializeField]
	protected GameObject selectRing;


	[SerializeField]
	private int _maxHealth;
	public virtual int MaxHealth
	{
		get
		{
			return _maxHealth;
		}
		set
		{
			float healthRate = (float)Health / _maxHealth;
			_maxHealth = value;
			Health = Mathf.CeilToInt(Health * healthRate);

		}
	}

	[SerializeField]
	private int _health;
	public virtual int Health {
		get
		{
			return _health;
		}
		set
		{
			_health = value;
		}
	}
	protected virtual void Start()
	{
		agent = GetComponent<NodalPathfinding2DAgent>();
	}

	public virtual void MoveTo(Vector2 destination)
	{
		agent.MoveTo(destination);
	}

	public abstract void OnSelected();
	public abstract void OnUnselected();
}
