﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace BS {
	[RequireComponent(typeof(Rigidbody2D))]
	[RequireComponent(typeof(CircleCollider2D))]
    public class NodalPathfinding2DAgent : MonoBehaviour
    {
        public NodalPathfinding2D pathFinder;

        public Vector3 destination;
        public List<Vector3> path = new List<Vector3>();
		public float moveSpeed;

        float t = 0.5f;

		private Rigidbody2D rb;

        public bool isGizmos = true;

        private void OnDrawGizmos()
        {
            if (!isGizmos)
                return;
            Gizmos.color = Color.white;
            if (path.Count > 0)
            {
                Gizmos.DrawLine(transform.position, path[0]);
                for (int i = 0; i < path.Count - 1; i++)
                {
                    Gizmos.DrawLine(path[i] + new Vector3(0,0,1), path[i + 1] + new Vector3(0, 0, 1));
                }
                Gizmos.color = Color.red;
                Gizmos.DrawSphere(destination + new Vector3(0, 0, 1), 0.2f);
            }
        }

		private void Start()
		{
			rb = GetComponent<Rigidbody2D>();
		}

		private void Update()
        {
			/*
            t -= Time.deltaTime;
            if (t < 0)
            {
                MoveTo(new Vector2(Random.Range(pathFinder.bounds.min.x, pathFinder.bounds.max.x), Random.Range(pathFinder.bounds.min.y, pathFinder.bounds.max.y)));
                t = 0.5f;
            }
			*/
			/*
			if (pathFinder.isBaked)
			{
				MoveTo(new Vector2(Random.Range(pathFinder.bounds.min.x, pathFinder.bounds.max.x), Random.Range(pathFinder.bounds.min.y, pathFinder.bounds.max.y)));
			}
			*/
			if (Input.GetKeyDown(KeyCode.Space))
            {
                transform.position = new Vector2(Random.Range(pathFinder.bounds.min.x, pathFinder.bounds.max.x), Random.Range(pathFinder.bounds.min.y, pathFinder.bounds.max.y));
            }
            if (Input.GetMouseButtonDown(1))
            {
				Vector3 destination = Camera.main.ScreenToWorldPoint(Input.mousePosition);
				destination.z = 0;

				MoveTo(destination);
            }
            //path = pathFinder.GetPathGreedy(transform.position, destination);
		}

        public void MoveTo(Vector3 destination)
        {
            this.destination = destination;
			//path = pathFinder.GetPathGreedy(transform.position, destination);
			if (path.Count > 1 && Vector2.Distance(path[path.Count - 1], destination) < pathFinder.pointInterval)
				path[path.Count - 1] = destination;
			else
			{
				path = pathFinder.GetPathAstar(transform.position, destination);
			}
		}

		public void Move(Vector2 direction)
		{

		}

		private void FixedUpdate()
		{
			if (path.Count > 0)
			{
				transform.position += (path[0] - transform.position).normalized * moveSpeed * Time.fixedDeltaTime;
				//rb.velocity = Vector3.Lerp(rb.velocity, (path[0] - transform.position).normalized * moveSpeed, 0.5f);
				//Debug.Log((path[0] - transform.position).normalized.magnitude);
				rb.velocity = (path[0] - transform.position).normalized * moveSpeed;

				if (path.Count > 1 && Vector2.Distance(transform.position, path[0]) < 0.1f && Vector2.Dot(path[1] - path[0], path[0] - transform.position) < 0)
				{
					path.RemoveAt(0);
				}
				else if (path.Count > 1 && Vector2.Distance(transform.position, path[0]) < pathFinder.pointInterval / 2)
				{
					path.RemoveAt(0);
				}
				else if (Vector2.Distance(transform.position, destination) < 0.05f)
				{
					rb.velocity = Vector3.zero;
					path.RemoveAt(0);
				}
			}
			if (rb.velocity.magnitude > 0.01f)
				transform.rotation = Quaternion.Lerp(transform.rotation, Quaternion.FromToRotation(Vector3.up, rb.velocity), 0.05f);
		}
	}
}