﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public enum TypingType
{
    LETTER,             // One letter typing time == dialogueTypingSpeed
    SENTENCE
}

public class DialogueSystem : MonoBehaviour
{
    public float dialogueTypingSpeed = 0.1f;
    public TypingType typingType = TypingType.LETTER;

    public Text dialogueText;
    public Text nameText;

    public Button nextDialogueButton;
    public Button prevDialogueButton;

    public List<Image> characterImages = new List<Image>();

    private DialogueScene dialogueScene;
    
    public void LoadDialogueScene(DialogueScene dialogueScene)
    {
        this.dialogueScene = dialogueScene;
    }

    public void NextDialogue()
    {
        Dialogue dialogue = dialogueScene.GetNextDialogue();
        nameText.text = dialogue.characterName;
        StartCoroutine(TypingDialogue(dialogue.dialogue));
    }

    public void PrevDialogue()
    {
        Dialogue dialogue = dialogueScene.GetPrevDialogue();
        nameText.text = dialogue.characterName;
        StartCoroutine(TypingDialogue(dialogue.dialogue));
    }

    public IEnumerator TypingDialogue(string dialogue)
    {
        float typingTime = dialogueTypingSpeed;
        if (typingType == TypingType.SENTENCE)
        {
            typingTime /= dialogue.Length;
        }

        for (int i = 0; i < dialogue.Length; i++)
        {
            dialogueText.text += dialogue[i];
            yield return new WaitForSeconds(dialogueTypingSpeed);
        }

    }
}