﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

using BS;

public class DialogueScene : ScriptableObject
{
    [SerializeField]
    private List<Dialogue> dialogues;
    private int dialogueIndex = 0;

    public bool IsEnd { get { return dialogueIndex >= dialogues.Count; } }
    public bool IsStart { get { return dialogueIndex == 0; } }

    public Dialogue GetNextDialogue()
    {
        return dialogues[dialogueIndex++];
    }

    public Dialogue GetPrevDialogue()
    {
        return dialogues[dialogueIndex--];
    }
}

[System.Serializable]
public struct Dialogue
{
    public string characterName;
    public string dialogue;
    public int imageIndex;
}