﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using BS;

enum CharacterControlMode
{
	DEFAULT,
	AIMING,
}

[RequireComponent(typeof(NodalPathfinding2DAgent))]
[RequireComponent(typeof(LineRenderer))]
public abstract class PlayableCharacter : Actor
{
	public float shotRange = 5.0f;
	public LayerMask shotBlockMask;

	protected LineRenderer lr;

	private float r = 0.0f;

	public bool isSelected = false;

	protected override void Start()
	{
		base.Start();
		lr = GetComponent<LineRenderer>();
		selectRing = transform.Find("SelectRing").gameObject;
	}

	protected virtual void Update()
	{
		if (isSelected)
		{
			r = Mathf.Min(shotRange, r + shotRange * Time.deltaTime);
			Vector3[] vertices = new Vector3[361];
			for (int i = 0; i < 360; i++)
			{
				Vector2 direction = (Quaternion.Euler(0, 0, i) * Vector2.right).normalized;
				RaycastHit2D hit = Physics2D.Raycast(transform.position, direction, r, shotBlockMask);

				if (hit.collider != null)
					vertices[i] = hit.point;
				else
					vertices[i] = transform.position + new Vector3(direction.x, direction.y) * r;
			}
			vertices[360] = vertices[0];

			lr.SetPositions(vertices);

		}
	}

	public override void OnSelected()
	{
		isSelected = true;
		lr.enabled = true;
		selectRing?.SetActive(true);
		r = 0;
	}

	public override void OnUnselected()
	{
		isSelected = false;
		lr.enabled = false;
		selectRing?.SetActive(false);
	}

	public override void MoveTo(Vector2 destination)
	{
		if (isSelected)
			agent.MoveTo(destination);
	}

	protected abstract void DefaultControl();
	protected abstract void AimingControl();
}
