﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;

public class DialogueSceneMakerWindow : EditorWindow
{
    [SerializeField]
    public List<Dialogue> dialogues = new List<Dialogue>();

    private string characterName;
    private string dialogueText;
    private int imageIndex;

    Vector2 scroll;
    private int loadFromDialoguesIndex = 0;

    Rect dialogueAdderWindowRect = new Rect(0, 0, 400, 400);
    Rect dialogueSceneMakerWindowRect = new Rect(400, 0, 400, 400);

    [MenuItem ("Tools/DialogueSceneMaker")]
    static void Init()
    {
        DialogueSceneMakerWindow window = (DialogueSceneMakerWindow)EditorWindow.GetWindow(typeof(DialogueSceneMakerWindow));
        window.minSize = new Vector2(800, 400);
        window.Show();
    }

    private void OnGUI()
    {
        /*
        EditorGUILayout.BeginHorizontal();

        EditorGUILayout.BeginVertical();
        GUILayout.Label("Dialogue Scene Maker", EditorStyles.boldLabel);
        EditorGUILayout.Space();
        characterName = EditorGUILayout.TextField("Character Name", characterName, GUILayout.MaxWidth(position.width / 2));
        imageIndex = EditorGUILayout.IntField("Character Image Index", imageIndex, GUILayout.MaxWidth(position.width / 2));
        GUILayout.Label("Dialogue");

        dialogueText = EditorGUILayout.TextArea(dialogueText,GUILayout.Height(200), GUILayout.MaxWidth(position.width / 2));

        if (GUILayout.Button("Add new Dialogue", GUILayout.MaxWidth(position.width / 2)))
        {
            dialogues.Add(new Dialogue(characterName,imageIndex, dialogueText));
            characterName = "";
            imageIndex = 0;
            dialogueText = "";
        }

        EditorGUILayout.BeginHorizontal();
        loadFromDialoguesIndex = EditorGUILayout.IntField(loadFromDialoguesIndex, GUILayout.MaxWidth(position.width / 4));
        if (GUILayout.Button("Load from current Dialogues", GUILayout.MaxWidth(position.width / 4)))
        {
            Dialogue dialogue = dialogues[loadFromDialoguesIndex];
            characterName = dialogue.characterName;
            imageIndex = dialogue.imageIndex;
            dialogueText = dialogue.dialogue;
        }
        EditorGUILayout.EndHorizontal();

        EditorGUILayout.EndVertical();

        EditorGUILayout.BeginVertical();
        scroll = GUILayout.BeginScrollView(scroll);

        var serializedObject = new SerializedObject(this);
        var list = serializedObject.FindProperty("dialogues");
        EditorGUILayout.PropertyField(serializedObject.FindProperty("dialogues"), true, GUILayout.MaxWidth(position.width / 2));
        GUILayout.EndScrollView();
        EditorGUILayout.EndVertical();

        EditorGUILayout.EndHorizontal();
        */
        BeginWindows();
        dialogueAdderWindowRect = GUILayout.Window(1, dialogueAdderWindowRect, DialogueAdderWindow, "Dialogue Adder");
        dialogueSceneMakerWindowRect = GUILayout.Window(2, dialogueSceneMakerWindowRect, DialogueSceneWindow, "Dialogue Scene Maker");
        EndWindows();
    }

    void DialogueAdderWindow(int id)
    {
        characterName = EditorGUILayout.TextField("Character Name", characterName, GUILayout.MaxWidth(position.width / 2));
        imageIndex = EditorGUILayout.IntField("Character Image Index", imageIndex, GUILayout.MaxWidth(position.width / 2));
        GUILayout.Label("Dialogue");

        dialogueText = EditorGUILayout.TextArea(dialogueText, GUILayout.Height(200), GUILayout.MaxWidth(position.width / 2));

        if (GUILayout.Button("Add new Dialogue", GUILayout.MaxWidth(position.width / 2)))
        {
            dialogues.Add(new Dialogue(characterName, imageIndex, dialogueText));
            characterName = "";
            imageIndex = 0;
            dialogueText = "";
        }

        EditorGUILayout.BeginHorizontal();
        loadFromDialoguesIndex = EditorGUILayout.IntField(loadFromDialoguesIndex, GUILayout.MaxWidth(position.width / 4));
        if (GUILayout.Button("Load from current Dialogues", GUILayout.MaxWidth(position.width / 4)))
        {
            Dialogue dialogue = dialogues[loadFromDialoguesIndex];
            characterName = dialogue.characterName;
            imageIndex = dialogue.imageIndex;
            dialogueText = dialogue.dialogue;
        }
        EditorGUILayout.EndHorizontal();

        GUI.DragWindow();
    }

    void DialogueSceneWindow(int id)
    {
        GUILayout.Label("Current dialogue list", EditorStyles.boldLabel);

        scroll = GUILayout.BeginScrollView(scroll);

        var serializedObject = new SerializedObject(this);
        var list = serializedObject.FindProperty("dialogues");
        for (int i = 0; i < dialogues.Count; i++)
        {
            EditorGUILayout.PropertyField(list.GetArrayElementAtIndex(i));
        }


        //EditorGUILayout.PropertyField(serializedObject.FindProperty("dialogues"), true, GUILayout.MaxWidth(position.width / 2));
        GUILayout.EndScrollView();

        GUI.DragWindow();
    }

    private void DialogueToEditorLayout(Dialogue dialogue)
    {

    }
}
