﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

using BS;

public class DialogueScene : ScriptableObject
{
    [SerializeField]
    private List<Dialogue> dialogues = new List<Dialogue>();
    private int dialogueIndex = 0;

    public bool IsEnd { get { return dialogueIndex >= dialogues.Count; } }
    public bool IsStart { get { return dialogueIndex == 0; } }

    public Dialogue GetNextDialogue()
    {
        return dialogues[dialogueIndex++];
    }

    public Dialogue GetPrevDialogue()
    {
        return dialogues[dialogueIndex--];
    }
}

[System.Serializable]
public struct Dialogue
{
    public Dialogue(string characterName, int imageIndex, string dialogue)
    {
        this.characterName = characterName;
        this.imageIndex = imageIndex;
        this.dialogue = dialogue;
    }

    public Dialogue(Dialogue dialogue)
    {
        this.characterName = dialogue.characterName;
        this.imageIndex = dialogue.imageIndex;
        this.dialogue = dialogue.dialogue;
    }

    public string characterName;
    [TextArea]
    public string dialogue;
    public int imageIndex;
}