﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class CameraController : MonoBehaviour
{
	public GameObject target = null;
	public bool isLocked = false;

	[SerializeField]
	private Vector3 offset = new Vector3(0, 0, -10);

	private Vector3 focusPoint;

    // Update is called once per frame
    void Update()
    {
		if (isLocked)
		{

		}
		transform.position = Vector3.Lerp(transform.position, focusPoint + offset, 0.4f);
    }

	public void SetFocusPoint(Vector2 focusPoint)
	{
		this.focusPoint = focusPoint;
	}

	public void MoveFocusPoint(Vector2 moveDelta)
	{
		this.focusPoint += new Vector3(moveDelta.x, moveDelta.y);
	}
}
