﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public abstract class Skill : ScriptableObject
{
    protected PlayableCharacter character;
    protected WeaponBehaviour weaponBehaviour;

	[SerializeField]
    private int m_tier;
	public int Tier { get { return m_tier; } }

	[SerializeField]
    private int m_index;
	public int Index { get { return m_index; } }

	[SerializeField]
	private Sprite m_skillImage;
	public Sprite SkillImage { get { return m_skillImage; } }

	[SerializeField]
	private float cooltime;
	protected float m_remainedCooltime = 0;
	public float RemainedCooltime { get { return m_remainedCooltime; } }

	public bool IsReady { get { return m_remainedCooltime <= 0; } }
	public float CooltimeRatio { get { return m_remainedCooltime / cooltime; } }

	public virtual void UpdateSkill(float deltaTime)
	{
		m_remainedCooltime = Mathf.Max(0, m_remainedCooltime - deltaTime);
		IngameUIManager.inst.UpdateSkillUI(this);
	}

    public virtual void Init(PlayableCharacter character)
    {
        this.character = character;
        this.weaponBehaviour = character.GetComponent<WeaponBehaviour>();
    }

    public abstract void Aiming();
    protected abstract void Use();
}
