﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;

public sealed class HeadShot : Skill
{
    public float damageTimes;
    private Collider2D target;

#if UNITY_EDITOR
    [MenuItem("Skiils/HeadShot")]
    static void CreateAsset()
    {
        HeadShot skill = CreateInstance<HeadShot>();
        AssetDatabase.CreateAsset(skill,"Assets/" + skill.GetType().Name + ".asset");
    }
#endif

    public override void Aiming()
    {
		weaponBehaviour.StartCoroutine(AimingRoutine());
    }

    private IEnumerator AimingRoutine()
    {
        while (true)
        {
			Vector3 mouseWorldPosition = Camera.main.ScreenToWorldPoint(Input.mousePosition);
			target = Physics2D.OverlapPoint(mouseWorldPosition, 1 << LayerMask.NameToLayer("Enemy"));
			if (Input.GetMouseButtonDown(0))
            {
                Use();
                break;
            }
            yield return null;
        }
    }

    protected override void Use()
    {
        if (!target)
            return;
		Debug.Log("A");
        target.GetComponent<Enemy>().Health -= Mathf.CeilToInt(weaponBehaviour.weapon.damage * damageTimes);
    }
}
