﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerController : MonoBehaviour
{
	[SerializeField]
	private new Camera camera;
	public float moveSpeed = 5.0f;

	private Vector3 clickPos;
	private Vector3 dragPos;
	private Vector3 releasePos;

	private void Awake()
	{
	}

	private void Update()
	{
		MouseControl();
	}

	public void MouseControl()
	{
		if (Input.GetMouseButtonDown(0))
		{
			clickPos = Camera.main.ScreenToWorldPoint(Input.mousePosition);
			IngameUIManager.inst.EnableDragUI();
		}
		if (Input.GetMouseButton(0))
		{
			dragPos = Camera.main.ScreenToWorldPoint(Input.mousePosition);
			IngameUIManager.inst.UpdateDragUI(clickPos, dragPos);
		}
		if (Input.GetMouseButtonUp(0))
		{
			releasePos = Camera.main.ScreenToWorldPoint(Input.mousePosition);
			IngameUIManager.inst.DisableDragUI();

			Vector2 size = clickPos - releasePos;
			size = size.Abs();
			foreach(var cast in Physics2D.OverlapBoxAll((clickPos + releasePos) / 2, size, 0))
			{
				Actor actor = cast.GetComponent<Actor>();
				if (actor != null)
				{
					actor.OnSelected();
				}
			}
		}
	}

	public void CameraControl()
	{
		float horizontal = 0;
		float vertical = 0;
		Vector2 mousePosition = Input.mousePosition;

		if (Screen.width - Input.mousePosition.x < Screen.width / 10)
		{
			horizontal = 1;
		}
		else if (Input.mousePosition.x < Screen.width / 10)
		{
			horizontal = -1;
		}

		if (Screen.height - Input.mousePosition.y < Screen.height / 10)
		{
			vertical = 1;
		}
		else if (Input.mousePosition.y < Screen.height / 10)
		{
			vertical = -1;
		}

		camera.transform.position += new Vector3(horizontal, vertical) * moveSpeed * Time.deltaTime;

		//camera.transform.position += new Vector3(Input.GetAxis("Horizontal"), Input.GetAxis("Vertical"), 0) * moveSpeed * Time.deltaTime;
	}

	public void OnMove(Vector2 direction)
	{
		Debug.Log("A");
		transform.position += new Vector3(direction.x, 0, direction.y).normalized * moveSpeed * Time.deltaTime;
	}
}
