﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class IngameUIManager : SingletonBehaviour<IngameUIManager>
{
	public RectTransform dragUI;



    // Start is called before the first frame update
    void Start()
    {
        
    }

    // Update is called once per frame
    void Update()
    {
        
    }

	public void EnableDragUI()
	{
		dragUI.gameObject.SetActive(true);
		dragUI.sizeDelta = Vector2.zero;
	}

	public void DisableDragUI()
	{
		dragUI.gameObject.SetActive(false);
	}

	public void UpdateDragUI(Vector2 startPoint, Vector2 endPoint)
	{
		startPoint = Camera.main.WorldToViewportPoint(startPoint);
		endPoint = Camera.main.WorldToViewportPoint(endPoint);

		Debug.Log("Start : " + startPoint + ", End : " + endPoint);

		dragUI.anchorMin = dragUI.anchorMax =  (startPoint + endPoint) / 2;

		Vector2 size = endPoint - startPoint;
		RectTransform rect = GetComponent<RectTransform>();

		size.x = Mathf.Abs(rect.sizeDelta.x * size.x);
		size.y = Mathf.Abs(rect.sizeDelta.y * size.y);
		dragUI.sizeDelta = size;
	}
}
