﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerController : SingletonBehaviour<PlayerController>
{
	[SerializeField]
	private new Camera camera;
	public float moveSpeed = 5.0f;
	public float zoomSpeed = 20.0f;

	private Vector3 clickPos;
	private Vector3 dragPos;
	private Vector3 releasePos;

	[SerializeField]
	private List<PlayableCharacter> characters = new List<PlayableCharacter>();

	private Vector3 lastMousePos;

	[SerializeField]
	private CameraController cc;

	private void Awake()
	{
	}

	private void Update()
	{
		CameraControl();
		MouseControl();
		KeyboardControl();
	}

	public void KeyboardControl()
	{
		for (int i = 0; i < characters.Count; i++)
		{
			if (Input.GetKeyDown(KeyCode.Alpha1 + i))
			{
				if (!Input.GetKey(KeyCode.LeftControl))
				{
					for (int j = 0; j < characters.Count; j++)
					{
						characters[j].OnUnselected();
					}
				}
				characters[i].OnSelected();
			}
		}
	}

	public void MouseControl()
	{
		if (Input.GetMouseButtonDown(0))
		{
			clickPos = Camera.main.ScreenToWorldPoint(Input.mousePosition);
			IngameUIManager.inst.EnableDragUI();
		}
		if (Input.GetMouseButton(0))
		{
			dragPos = Camera.main.ScreenToWorldPoint(Input.mousePosition);
			IngameUIManager.inst.UpdateDragUI(clickPos, dragPos);
		}
		if (Input.GetMouseButtonUp(0))
		{
			releasePos = Camera.main.ScreenToWorldPoint(Input.mousePosition);
			IngameUIManager.inst.DisableDragUI();

			Vector2 size = clickPos - releasePos;
			size = size.Abs();

			List<PlayableCharacter> selectedCharacters = new List<PlayableCharacter>();
			List<Enemy> selectedEnemies = new List<Enemy>();
			foreach (var cast in Physics2D.OverlapBoxAll((clickPos + releasePos) / 2, size, 0))
			{
				Actor actor = cast.GetComponent<Actor>();
				if (actor != null)
				{
					if (actor is PlayableCharacter)
					{
						selectedCharacters.Add((PlayableCharacter)actor);
					}
					else if (actor is Enemy)
					{
						selectedEnemies.Add((Enemy)actor);
					}
				}
			}

			if (selectedCharacters.Count > 0)
			{
				if (!Input.GetKey(KeyCode.LeftControl))
				{
					foreach(var character in characters)
					{
						character.OnUnselected();
					}
				}
				foreach(var character in selectedCharacters)
				{
					character.OnSelected();
				}
			}
			else if (selectedEnemies.Count < 1)
			{
				foreach (var character in characters)
				{
					character.OnUnselected();
				}
			}
			else
			{
				foreach (var enemy in selectedEnemies)
				{
					enemy.OnSelected();
				}
			}
		}
		if (Input.GetMouseButton(1))
		{
			foreach (var character in characters)
			{
				character.MoveTo(Camera.main.ScreenToWorldPoint(Input.mousePosition));
			}
		}
	}

	public void CameraControl()
	{
		/*
		float horizontal = 0;
		float vertical = 0;
		Vector2 mousePosition = Input.mousePosition;

		if (Screen.width - Input.mousePosition.x < Screen.width / 10)
		{
			horizontal = 1;
		}
		else if (Input.mousePosition.x < Screen.width / 10)
		{
			horizontal = -1;
		}

		if (Screen.height - Input.mousePosition.y < Screen.height / 10)
		{
			vertical = 1;
		}
		else if (Input.mousePosition.y < Screen.height / 10)
		{
			vertical = -1;
		}

		cc.MoveFocusPoint(new Vector3(horizontal, vertical) * moveSpeed * Time.deltaTime);
		*/

		if (Input.GetMouseButton(2))
		{
			Vector3 mouseMoveDelta = Camera.main.ScreenToWorldPoint(Input.mousePosition) - camera.ScreenToWorldPoint(lastMousePos);
			cc.MoveFocusPoint(-mouseMoveDelta * moveSpeed);
		}
		lastMousePos = Input.mousePosition;

		camera.orthographicSize -= zoomSpeed * Input.mouseScrollDelta.y * Time.deltaTime;
	}

	public void SelectCharacter(int index)
	{
		characters[index].OnSelected();
		if (!Input.GetKey(KeyCode.LeftControl))
		{
			for (int i = 0; i < characters.Count; i++)
			{
				if (i == index)
					continue;
				characters[i].OnUnselected();
			}
		}
	}
}
