﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class AssaultRifle : Weapon
{
	public int bulletsPerShot;
	public float bulletInterval;

	public override void OnAttack(Enemy enemy)
	{
		if (IsReady)
		{
			behaviour.StartCoroutine(ShotBullet(enemy));
			shotTimer = shotInterval;
		}
	}

	private IEnumerator ShotBullet(Enemy enemy)
	{
		for (int i = 0; i < bulletsPerShot; i++)
		{
			enemy.Health -= damage + Random.Range(-damageRandomRange, damageRandomRange + 1);
			behaviour.EmitBulletParticle();
			yield return new WaitForSeconds(bulletInterval);
		}
	}
}
