﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public enum TypingType
{
    LETTER,             // One letter typing time == dialogueTypingSpeed
    SENTENCE
}

public class DialogueSystem : MonoBehaviour
{
    public float dialogueTypingSpeed = 0.1f;
    public TypingType typingType = TypingType.LETTER;

    public Text dialogueText;
    public Text nameText;

    public Button nextDialogueButton;
    public Button prevDialogueButton;

    public List<Image> characterImages = new List<Image>();

	[SerializeField]
    private DialogueScene dialogueScene;

    public string nextButton, prevButton;

	public Image testImage;

	private Dictionary<int, CharacterResource> characterResources = new Dictionary<int, CharacterResource>();

	private void Start()
	{
		foreach (var resource in Resources.LoadAll<CharacterResource>("BS_DialogueSystem/CharacterResources"))
		{
			characterResources.Add(resource.characterID, resource);
		}
		
		if (dialogueScene != null)
		{
			dialogueScene.Init();
			NextDialogue();
		}
	}

	private void Update()
    {
		/*
        if (Input.GetButtonDown(nextButton))
        {
            NextDialogue();
        }
        if (Input.GetButtonDown(prevButton))
        {
            PrevDialogue();
        }
		*/
		if (Input.GetKeyDown(KeyCode.RightArrow))
		{
			NextDialogue();
		}
		if (Input.GetKeyDown(KeyCode.LeftArrow))
		{
			PrevDialogue();
		}
	}

    public void StartDialogueScene(DialogueScene dialogueScene)
    {
        this.dialogueScene = dialogueScene;

    }

    public void NextDialogue()
    {
        if (dialogueScene.IsEnd)
        {
			return;
        }
        Dialogue dialogue = dialogueScene.GetNextDialogue();
        nameText.text = dialogue.characterName;
		int i = 0;
		for (; i < dialogue.characterIDs.Count; i++)
		{
			characterImages[i].enabled = true;
			characterImages[i].sprite = characterResources[dialogue.characterIDs[i]].GetCharacterImage(dialogue.expressions[i]);
		}
		for (; i < characterImages.Count; i++)
		{
			characterImages[i].enabled = false;
		}
		StopAllCoroutines();
		StartCoroutine(TypingDialogue(dialogue.dialogue));
    }

    public void PrevDialogue()
    {
        if (dialogueScene.IsStart)
        {
            return;
        }
        Dialogue dialogue = dialogueScene.GetPrevDialogue();
		nameText.text = dialogue.characterName;
		int i = 0;
		for (; i < dialogue.characterIDs.Count; i++)
		{
			characterImages[i].enabled = true;
			characterImages[i].sprite = characterResources[dialogue.characterIDs[i]].GetCharacterImage(dialogue.expressions[i]);
		}
		for (; i < characterImages.Count; i++)
		{
			characterImages[i].enabled = false;
		}
		StopAllCoroutines();
        StartCoroutine(TypingDialogue(dialogue.dialogue));
    }

    public IEnumerator TypingDialogue(string dialogue)
    {
        float typingTime = dialogueTypingSpeed;
        if (typingType == TypingType.SENTENCE)
        {
            typingTime /= dialogue.Length;
        }

		dialogueText.text = "";

		for (int i = 0; i < dialogue.Length; i++)
        {
            dialogueText.text += dialogue[i];
            yield return new WaitForSeconds(typingTime);
        }

    }
}