﻿using System.Collections;
using System.Collections.Generic;
using UnityEditor;
using UnityEngine;

#if UNITY_EDITOR
[CustomEditor(typeof(Enemy))]
public class EnemyEditor : Editor
{
	private Enemy enemy;

	private void OnEnable()
	{
		enemy = (Enemy)target;
	}

	private void OnSceneGUI()
	{
		for (int i = 0; i < enemy.RoamingPath.Count; i++)
		{
			EditorGUI.BeginChangeCheck();
			Vector3 newPosition = Handles.FreeMoveHandle(enemy.RoamingPath[i], Quaternion.identity, 1f, Vector3.one, Handles.CircleHandleCap);
			if (EditorGUI.EndChangeCheck())
			{
				enemy.RoamingPath[i] = newPosition;
			}
		}

		SceneView.RepaintAll();
	}
}

#endif